package de.serra.graph_walker;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

class GraphWalkerArrayMemberState extends GraphWalkerStackFrame<@Nullable Object[]> {
	private int idx;

	GraphWalkerArrayMemberState(final @Nullable Object[] value, int idx) {
		super(State.ARRAY_MEMBER, value);
		this.idx = idx;
	}

	@Pure
	public @Nullable Object member() {
		return value()[idx];
	}

	public boolean tryGoNextMember() {
		idx++;
		var ret = idx < value().length;
		if (ret) {
			resetDirection();
		}
		return ret;
	}

	@Pure
	public int idx() {
		return idx;
	}
}
