package de.serra.graph_walker;

/**
 * Allows to control the traversal.
 *
 * @author Peter Lamby
 */
public abstract class VisitController {
	/**
	 * Constructs.
	 */
	protected VisitController() {
	}

	/**
	 * Immediatly stop the traversal. No more visit methods will be called.
	 *
	 * @see #isStopped()
	 */
	public abstract void stop();

	/**
	 * Don't visit any children of the current value.
	 */
	public abstract void dontGoDeeper();

	/**
	 * Determin if the visit was stopped by {@link #stop()}.
	 *
	 * @return {@code true} if the visit is stopped and {@code false} otherwise.
	 * @see #stop()
	 */
	public abstract boolean isStopped();

	/**
	 * Creates a "sub" graphwalk from the current position.
	 * <p>
	 * It remembers the already visited nodes but otherwise acts as a walk on it's own.
	 *
	 * @param visitor The visitor to use for this GraphWalk.
	 * @return the new graph walk.
	 */
	public abstract GraphWalk createSubWalk(ObjectgraphVisitor visitor);
}
