/*
 * Decompiled with CFR 0.152.
 */
package de.serra.graph_walker;

import de.serra.graph_walker.GraphWalkerArrayMemberState;
import de.serra.graph_walker.GraphWalkerClassFieldState;
import de.serra.graph_walker.GraphWalkerClassState;
import de.serra.graph_walker.GraphWalkerStackFrame;
import de.serra.graph_walker.ObjectgraphVisitor;
import de.serra.graph_walker.VisitController;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class GraphWalk {
    private final @UnknownKeyFor @NonNull @Initialized ObjectgraphVisitor visitor;
    private final @Nullable @UnknownKeyFor @Initialized GraphWalk parentWalk;
    private @UnknownKeyFor @NonNull @Initialized Control control = Control.CONTINUE;
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized GraphWalkerStackFrame<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> @UnknownKeyFor @NonNull @Initialized [] stack = new GraphWalkerStackFrame[16];
    private @UnknownKeyFor @NonNull @Initialized int stackSize;
    private @UnknownKeyFor @NonNull @Initialized VisitController controller;

    public GraphWalk(@UnknownKeyFor @NonNull @Initialized ObjectgraphVisitor visitor) {
        this(visitor, null);
    }

    private GraphWalk(@UnknownKeyFor @NonNull @Initialized ObjectgraphVisitor visitor, @Nullable @UnknownKeyFor @Initialized GraphWalk parentWalk) {
        this.visitor = visitor;
        this.parentWalk = parentWalk;
        this.controller = new GraphWalkVisitController();
    }

    public void walk(@Nullable @UnknownKeyFor @Initialized Object toWalk) {
        if (toWalk == null) {
            this.visitor.visitNull(this.controller);
            return;
        }
        this.stack[0] = new GraphWalkerStackFrame<Object>(GraphWalkerStackFrame.State.BEFORE_OBJECT, toWalk);
        ++this.stackSize;
        this.dispatch();
        this.control = Control.CONTINUE;
        this.stack[0] = new GraphWalkerStackFrame<Object>(GraphWalkerStackFrame.State.BEFORE_OBJECT, toWalk);
        this.stackSize = 0;
        for (int i = 1; i < this.stack.length; ++i) {
            this.stack[i] = null;
        }
        this.controller = new GraphWalkVisitController();
    }

    public @UnknownKeyFor @NonNull @Initialized GraphWalk createSubwalk(@UnknownKeyFor @NonNull @Initialized ObjectgraphVisitor visitor) {
        return new GraphWalk(visitor, this);
    }

    protected void dispatch() {
        while (!this.isDone()) {
            GraphWalkerStackFrame<?> stackFrame = this.currentStackFrame();
            switch (stackFrame.state()) {
                case BEFORE_OBJECT: {
                    this.beforeObject();
                    break;
                }
                case ARRAY: {
                    this.visitArray();
                    break;
                }
                case ARRAY_MEMBER: {
                    this.visitArrayMember();
                    break;
                }
                case CLASS: {
                    this.visitClass();
                    break;
                }
                case CLASS_FIELD: {
                    this.visitClassField();
                    break;
                }
            }
        }
    }

    protected void beforeObject() {
        boolean alreadySeen;
        GraphWalkerStackFrame<?> stackFrame = this.currentStackFrame();
        if (stackFrame.isLeaving()) {
            this.leave();
            return;
        }
        Object value = stackFrame.value();
        boolean bl = alreadySeen = value != null && this.alreadySeen(value);
        if (this.parentWalk != null) {
            alreadySeen |= value != null && this.parentWalk.alreadySeen(value);
            alreadySeen |= this.parentWalk.currentStackFrame().value() == value;
        }
        this.visitor.beforeObject(value, this.controller, alreadySeen);
        if (this.isStopped()) {
            return;
        }
        if (alreadySeen || this.isDontGoDeeper()) {
            this.leave();
            return;
        }
        if (value == null) {
            this.visitor.visitNull(this.controller);
            this.leave();
            return;
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            this.pushOnStack(new GraphWalkerStackFrame(GraphWalkerStackFrame.State.ARRAY, value));
            return;
        }
        this.pushOnStack(new GraphWalkerClassState(value));
    }

    protected void visitArray() {
        GraphWalkerStackFrame<?> stackFrame = this.currentStackFrame();
        if (stackFrame.isLeaving()) {
            this.leave();
            return;
        }
        assert (!this.isDontGoDeeper()) : "isDontGoDeeper in visitArray";
        Object array = stackFrame.value();
        assert (array != null) : "visitArray should never be called with null array";
        Class<?> arrayType = array.getClass();
        Class<?> componentType = arrayType.getComponentType();
        if (componentType == Byte.TYPE) {
            this.visitor.visitByteArray((byte[])array, this.controller);
            this.leave();
        } else if (componentType == Short.TYPE) {
            this.visitor.visitShortArray((short[])array, this.controller);
            this.leave();
        } else if (componentType == Integer.TYPE) {
            this.visitor.visitIntArray((int[])array, this.controller);
            this.leave();
        } else if (componentType == Long.TYPE) {
            this.visitor.visitLongArray((long[])array, this.controller);
            this.leave();
        } else if (componentType == Float.TYPE) {
            this.visitor.visitFloatArray((float[])array, this.controller);
            this.leave();
        } else if (componentType == Double.TYPE) {
            this.visitor.visitDoubleArray((double[])array, this.controller);
            this.leave();
        } else if (componentType == Boolean.TYPE) {
            this.visitor.visitBooleanArray((boolean[])array, this.controller);
            this.leave();
        } else if (componentType == Character.TYPE) {
            this.visitor.visitCharArray((char[])array, this.controller);
            this.leave();
        } else {
            Object[] objectArray = (Object[])array;
            this.visitor.visitArray(objectArray, this.controller);
            if (!this.isDontGoDeeper() && objectArray.length > 0) {
                this.pushOnStack(new GraphWalkerArrayMemberState(objectArray, 0));
            } else {
                if (!this.isStopped()) {
                    this.visitor.leaveArray(objectArray, this.controller);
                }
                this.leave();
                return;
            }
        }
    }

    protected void visitArrayMember() {
        GraphWalkerArrayMemberState stackFrame = (GraphWalkerArrayMemberState)this.currentStackFrame();
        if (!stackFrame.isLeaving()) {
            assert (!this.isDontGoDeeper()) : "isDontGoDeeper in visitArrayMember";
            this.visitor.visitArrayMember(stackFrame.member(), stackFrame.idx(), (Object[])stackFrame.value(), this.controller);
            if (this.isStopped()) {
                return;
            }
            if (!this.isDontGoDeeper()) {
                this.pushOnStack(new GraphWalkerStackFrame<Object>(GraphWalkerStackFrame.State.BEFORE_OBJECT, stackFrame.member()));
                return;
            }
        }
        this.visitor.leaveArrayMember(stackFrame.member(), stackFrame.idx(), (Object[])stackFrame.value(), this.controller);
        if (this.isStopped()) {
            return;
        }
        this.resetControl();
        if (stackFrame.tryGoNextMember()) {
            return;
        }
        this.visitor.leaveArray((Object[])stackFrame.value(), this.controller);
        this.leave();
    }

    protected void visitClass() {
        Field[] fields;
        GraphWalkerClassState stackFrame = (GraphWalkerClassState)this.currentStackFrame();
        if (!stackFrame.fieldsAlreadyVisited()) {
            if (!stackFrame.isUpwardsInClassHierarchy()) {
                this.visitor.visitClass(stackFrame.value(), this.controller);
            } else {
                this.visitor.visitSuperClass(stackFrame.value(), stackFrame.getPositionInClassHierarchy(), this.controller);
            }
        }
        if (this.isStopped()) {
            return;
        }
        if (!this.isDontGoDeeper() && !stackFrame.fieldsAlreadyVisited() && (fields = stackFrame.getPositionInClassHierarchy().getDeclaredFields()).length > 0) {
            this.pushOnStack(new GraphWalkerClassFieldState(stackFrame.value(), fields));
            return;
        }
        if (!this.isDontGoSuper() && stackFrame.tryGoUpInClassHierarchy()) {
            return;
        }
        this.visitor.leaveClass(stackFrame.value(), this.controller);
        this.leave();
    }

    protected void visitClassField() {
        GraphWalkerClassFieldState stackFrame = (GraphWalkerClassFieldState)this.currentStackFrame();
        if (!stackFrame.isLeaving()) {
            assert (!this.isDontGoDeeper()) : "isDontGoDeeper in visitClassField";
            this.visitor.visitClassField(stackFrame.value(), stackFrame.getField(), this.controller);
            if (this.isStopped()) {
                return;
            }
            if (!this.isDontGoDeeper()) {
                boolean canAccess;
                Field field = stackFrame.getField();
                Object instance = stackFrame.value();
                boolean shouldVisit = true;
                if ((shouldVisit &= !field.getType().isPrimitive()) && !(canAccess = Modifier.isStatic(field.getModifiers()) ? this.canAccessStaticField(field) : field.canAccess(instance))) {
                    shouldVisit &= field.trySetAccessible();
                }
                if (shouldVisit) {
                    try {
                        Object fieldValue = field.get(instance);
                        this.pushOnStack(new GraphWalkerStackFrame<Object>(GraphWalkerStackFrame.State.BEFORE_OBJECT, fieldValue));
                        return;
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        // empty catch block
                    }
                }
            }
        }
        this.visitor.leaveClassField(stackFrame.value(), stackFrame.getField(), this.controller);
        if (this.isStopped()) {
            return;
        }
        this.resetControl();
        if (stackFrame.tryGoNextField()) {
            return;
        }
        this.goBack();
        GraphWalkerClassState classState = (GraphWalkerClassState)this.currentStackFrame();
        classState.fieldsDone();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean canAccessStaticField(@UnknownKeyFor @NonNull @Initialized Field f) {
        assert (Modifier.isStatic(f.getModifiers())) : "Field is not static";
        return f.canAccess(null);
    }

    @Pure
    protected @UnknownKeyFor @NonNull @Initialized boolean isDone() {
        return this.stackSize == 0 || this.control == Control.STOP;
    }

    @Pure
    protected @UnknownKeyFor @NonNull @Initialized boolean isStopped() {
        return this.control == Control.STOP;
    }

    @Pure
    protected @UnknownKeyFor @NonNull @Initialized boolean isDontGoDeeper() {
        return this.control == Control.STOP || this.control == Control.CONTINUE_BUT_DONT_GO_DEEPER;
    }

    @Pure
    protected @UnknownKeyFor @NonNull @Initialized boolean isDontGoSuper() {
        return this.control == Control.STOP || this.control == Control.CONTINUE_BUT_DONT_GO_SUPER;
    }

    @Pure
    protected /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized GraphWalkerStackFrame<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> currentStackFrame() {
        return this.relativeFromCurrent(0);
    }

    @Pure
    protected /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized GraphWalkerStackFrame<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> relativeFromCurrent(@UnknownKeyFor @NonNull @Initialized int offset) {
        assert (this.stackSize > 0 + offset) : "Illegal State. No more element in stack";
        GraphWalkerStackFrame<?> ret = this.stack[this.stackSize - (offset + 1)];
        assert (ret != null) : "Illegal State. Trying to access non existing stack element";
        return ret;
    }

    protected void leave() {
        GraphWalkerStackFrame<?> state;
        this.goBack();
        if (!this.isDone() && (state = this.currentStackFrame()) != null) {
            state.leave();
        }
    }

    @Pure
    protected @UnknownKeyFor @NonNull @Initialized boolean alreadySeen(@UnknownKeyFor @NonNull @Initialized Object o) {
        for (int i = this.stackSize - 2; i >= 0; --i) {
            assert (this.stack[i] != null);
            if (this.stack[i].state() != GraphWalkerStackFrame.State.BEFORE_OBJECT || this.stack[i].value() != o) continue;
            return true;
        }
        return false;
    }

    protected void pushOnStack(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized GraphWalkerStackFrame<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> statestackFrame) {
        if (this.stackSize == this.stack.length) {
            this.grow(this.stackSize + 1);
        }
        this.stack[this.stackSize] = statestackFrame;
        ++this.stackSize;
    }

    protected void grow(@UnknownKeyFor @NonNull @Initialized int minCapacity) {
        int oldCapacity = this.stack.length;
        int newCapacity = Math.max(oldCapacity + oldCapacity >> 1, minCapacity);
        this.stack = Arrays.copyOf(this.stack, newCapacity);
    }

    protected void resetControl() {
        assert (this.control != Control.STOP) : "Should never try to continue after stop.";
        this.control = Control.CONTINUE;
    }

    protected void goBack() {
        --this.stackSize;
        this.stack[this.stackSize] = null;
    }

    public static enum Control {
        STOP,
        CONTINUE,
        CONTINUE_BUT_DONT_GO_DEEPER,
        CONTINUE_BUT_DONT_GO_SUPER;

    }

    private class GraphWalkVisitController
    extends VisitController {
        private GraphWalkVisitController() {
        }

        @Override
        public void stop() {
            GraphWalk.this.control = Control.STOP;
        }

        @Override
        public void dontGoDeeper() {
            if (GraphWalk.this.control == Control.STOP) {
                throw new IllegalStateException("Cant set dontGoDeeper if already stopped");
            }
            GraphWalk.this.control = Control.CONTINUE_BUT_DONT_GO_DEEPER;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isStopped() {
            return GraphWalk.this.control == Control.STOP;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized GraphWalk createSubWalk(@UnknownKeyFor @NonNull @Initialized ObjectgraphVisitor visitor) {
            return GraphWalk.this.createSubwalk(visitor);
        }
    }
}

