/*
 * Decompiled with CFR 0.152.
 */
package de.serra.graph_walker;

import de.serra.graph_walker.GraphWalkerArrayMemberState;
import de.serra.graph_walker.GraphWalkerClassFieldState;
import de.serra.graph_walker.GraphWalkerClassState;
import de.serra.graph_walker.GraphWalkerContext;
import de.serra.graph_walker.GraphWalkerState;
import de.serra.graph_walker.ObjectgraphVisitor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class GraphWalker {
    private GraphWalker() {
    }

    public static void visit(@UnknownKeyFor @NonNull @Initialized Object toVisit, @UnknownKeyFor @NonNull @Initialized ObjectgraphVisitor visitor) {
        GraphWalkerContext ctx = new GraphWalkerContext(toVisit, visitor);
        if (toVisit == null) {
            visitor.visitNull(ctx.getController());
            return;
        }
        GraphWalker.visit(ctx);
    }

    private static void visit(@UnknownKeyFor @NonNull @Initialized GraphWalkerContext ctx) {
        block7: while (!ctx.isDone()) {
            GraphWalkerState<?> current = ctx.current();
            assert (current != null) : "When we are not done current() should have a state";
            switch (current.state) {
                case OBJECT: {
                    GraphWalker.dispatchObject(ctx);
                    continue block7;
                }
                case ARRAY: {
                    GraphWalker.visitArray(ctx);
                    continue block7;
                }
                case ARRAY_MEMBER: {
                    GraphWalker.visitArrayMember(ctx);
                    continue block7;
                }
                case CLASS: {
                    GraphWalker.visitClass(ctx);
                    continue block7;
                }
                case CLASS_FIELD: {
                    GraphWalker.visitClassField(ctx);
                    continue block7;
                }
            }
            assert (false) : "Illegal State. The state is not known";
        }
    }

    private static void dispatchObject(@UnknownKeyFor @NonNull @Initialized GraphWalkerContext ctx) {
        GraphWalkerState<?> state = ctx.current();
        assert (state != null) : "dispatchObject should never be called with null state";
        if (state.isLeaving()) {
            ctx.leave();
            return;
        }
        Object value = state.value;
        boolean alreadySeen = value != null && ctx.alreadySeen(value);
        ctx.visitor.beforeObject(value, ctx.getController(), alreadySeen);
        if (ctx.isStopped()) {
            return;
        }
        if (alreadySeen || ctx.isDontGoDeeper()) {
            ctx.leave();
            return;
        }
        if (value == null) {
            ctx.visitor.visitNull(ctx.getController());
            ctx.leave();
            return;
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            ctx.pushOnStack(value, GraphWalkerState.State.ARRAY);
            return;
        }
        ctx.pushOnStack(new GraphWalkerClassState(value));
    }

    private static void visitArray(@UnknownKeyFor @NonNull @Initialized GraphWalkerContext ctx) {
        assert (ctx.current() != null) : "visitArray should never be called with null state";
        if (ctx.current().isLeaving()) {
            ctx.leave();
            return;
        }
        assert (!ctx.isDontGoDeeper()) : "isDontGoDeeper in visitArray. This doesn't make sense";
        Object array = ctx.current().value;
        assert (array != null) : "visitArray should never be called with null array";
        Class<?> arrayType = array.getClass();
        Class<?> componentType = arrayType.getComponentType();
        if (componentType == Byte.TYPE) {
            ctx.visitor.visitByteArray((byte[])array, ctx.getController());
            ctx.leave();
        } else if (componentType == Short.TYPE) {
            ctx.visitor.visitShortArray((short[])array, ctx.getController());
            ctx.leave();
        } else if (componentType == Integer.TYPE) {
            ctx.visitor.visitIntArray((int[])array, ctx.getController());
            ctx.leave();
        } else if (componentType == Long.TYPE) {
            ctx.visitor.visitLongArray((long[])array, ctx.getController());
            ctx.leave();
        } else if (componentType == Float.TYPE) {
            ctx.visitor.visitFloatArray((float[])array, ctx.getController());
            ctx.leave();
        } else if (componentType == Double.TYPE) {
            ctx.visitor.visitDoubleArray((double[])array, ctx.getController());
            ctx.leave();
        } else if (componentType == Boolean.TYPE) {
            ctx.visitor.visitBooleanArray((boolean[])array, ctx.getController());
            ctx.leave();
        } else if (componentType == Character.TYPE) {
            ctx.visitor.visitCharArray((char[])array, ctx.getController());
            ctx.leave();
        } else {
            Object[] objectArray = (Object[])array;
            ctx.visitor.visitArray(objectArray, ctx.getController());
            if (!ctx.isDontGoDeeper() && objectArray.length > 0) {
                ctx.pushOnStack(new GraphWalkerArrayMemberState(objectArray[0], 0));
            } else {
                if (!ctx.isStopped()) {
                    ctx.visitor.leaveArray(objectArray, ctx.getController());
                }
                ctx.leave();
                return;
            }
        }
    }

    private static void visitArrayMember(@UnknownKeyFor @NonNull @Initialized GraphWalkerContext ctx) {
        GraphWalkerArrayMemberState memberState = (GraphWalkerArrayMemberState)ctx.current();
        assert (memberState != null) : "visitArrayMember should never be called with null state";
        assert (ctx.relativeFromCurrent(1) != null) : "visitArrayMember should have a direct parent";
        assert (ctx.relativeFromCurrent((int)1).value instanceof Object[]) : "visitArrayMember should have Object[] as direct parent";
        @Nullable Object[] array = (Object[])ctx.relativeFromCurrent((int)1).value;
        assert (array != null) : "Illegal state. The array itself can't be null when visiting one of its members.";
        if (!memberState.isLeaving()) {
            assert (!ctx.isDontGoDeeper()) : "Illegal state";
            ctx.visitor.visitArrayMember(memberState.value, memberState.idx, array, ctx.getController());
            if (ctx.isStopped()) {
                return;
            }
            if (!ctx.isDontGoDeeper()) {
                ctx.pushOnStack(memberState.value, GraphWalkerState.State.OBJECT);
                return;
            }
        }
        ctx.resetControl();
        int nextMemberIdx = memberState.idx + 1;
        if (nextMemberIdx < array.length) {
            ctx.replaceCurrent(new GraphWalkerArrayMemberState(array[nextMemberIdx], nextMemberIdx));
        } else {
            ctx.visitor.leaveArray(array, ctx.getController());
            ctx.leave();
        }
    }

    private static void visitClass(@UnknownKeyFor @NonNull @Initialized GraphWalkerContext ctx) {
        Field[] fields;
        GraphWalkerClassState state = (GraphWalkerClassState)ctx.current();
        assert (state != null) : "Illegal state. The instance can not be null when visiting its class";
        assert (!ctx.isDontGoDeeper()) : "isDontGoDeeper set. Should have been caught by dispatchObject";
        if (!state.fieldsAlreadyVisited()) {
            if (!state.isUpwardsInClassHierarchy()) {
                ctx.visitor.visitClass(state.value, ctx.getController());
            } else {
                ctx.visitor.visitSuperClass(state.value, state.getPositionInClassHierarchy(), ctx.getController());
            }
        }
        if (ctx.isStopped()) {
            return;
        }
        if (!ctx.isDontGoDeeper() && !state.fieldsAlreadyVisited() && (fields = state.getPositionInClassHierarchy().getDeclaredFields()).length > 0) {
            ctx.pushOnStack(new GraphWalkerClassFieldState(state.value, fields));
            return;
        }
        if (!ctx.isDontGoSuper() && state.tryGoUpInClassHierarchy()) {
            return;
        }
        ctx.visitor.leaveClass(state.value, ctx.getController());
        ctx.leave();
    }

    private static void visitClassField(@UnknownKeyFor @NonNull @Initialized GraphWalkerContext ctx) {
        GraphWalkerClassFieldState state = (GraphWalkerClassFieldState)ctx.current();
        assert (state != null) : "Illegal state. The instance can not be null when visiting its fields";
        if (!state.isLeaving()) {
            assert (!ctx.isDontGoDeeper()) : "Illegal state";
            assert (!ctx.isStopped()) : "Illegal state";
            ctx.visitor.visitClassField(state.value, state.getField(), ctx.getController());
            if (ctx.isStopped()) {
                return;
            }
            if (!ctx.isDontGoDeeper()) {
                Field field = state.getField();
                Object instance = state.value;
                boolean shouldVisit = true;
                shouldVisit &= !field.getType().isPrimitive();
                if ((shouldVisit &= !Modifier.isStatic(field.getModifiers())) && !field.canAccess(instance)) {
                    shouldVisit &= field.trySetAccessible();
                }
                if (shouldVisit) {
                    try {
                        Object fieldValue = field.get(instance);
                        ctx.pushOnStack(fieldValue, GraphWalkerState.State.OBJECT);
                        return;
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {}
                }
            }
        } else if (ctx.isStopped()) {
            return;
        }
        ctx.resetControl();
        if (state.tryGoNextField()) {
            return;
        }
        ctx.goBack();
        GraphWalkerClassState classState = (GraphWalkerClassState)ctx.current();
        assert (classState != null) : "Illegal state";
        classState.fieldsDone();
    }
}

