package de.serra.graph_walker;

import java.lang.reflect.Field;

class GraphWalkerClassFieldState extends GraphWalkerState<Object> {
	final Field[] fields;
	private int idx;

	GraphWalkerClassFieldState(Object value, Field[] fields) {
		super(State.CLASS_FIELD, value);
		assert fields.length > 0;

		this.fields = fields;
	}

	public Field getField() {
		return fields[idx];
	}

	public boolean tryGoNextField() {
		idx++;
		var ret = idx < fields.length;
		if (ret) {
			resetDirection();
		}
		return ret;
	}

	public int getFieldIdx() {
		return idx;
	}
}
