/*
 * Decompiled with CFR 0.152.
 */
package de.serra.graph_walker;

import de.serra.graph_walker.GraphWalkerState;
import de.serra.graph_walker.ObjectgraphVisitor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

class GraphWalkerContext {
    final @UnknownKeyFor @NonNull @Initialized ObjectgraphVisitor visitor;
    @UnknownKeyFor @NonNull @Initialized Control control = Control.CONTINUE;
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized GraphWalkerState<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> @UnknownKeyFor @NonNull @Initialized [] stack = new GraphWalkerState[16];
    private @UnknownKeyFor @NonNull @Initialized int stackSize;
    @NotOnlyInitialized
    private final @UnknownKeyFor @NonNull @Initialized VisitController controller;

    GraphWalkerContext(@UnknownKeyFor @NonNull @Initialized Object start, @UnknownKeyFor @NonNull @Initialized ObjectgraphVisitor visitor) {
        this.visitor = visitor;
        this.stack[0] = new GraphWalkerState<Object>(GraphWalkerState.State.OBJECT, start);
        ++this.stackSize;
        this.controller = new VisitController(this);
    }

    public @UnknownKeyFor @NonNull @Initialized VisitController getController() {
        return this.controller;
    }

    void goBack() {
        --this.stackSize;
    }

    @UnknownKeyFor @NonNull @Initialized boolean alreadySeen(@UnknownKeyFor @NonNull @Initialized Object o) {
        for (int i = this.stackSize - 2; i >= 0; --i) {
            assert (this.stack[i] != null);
            if (this.stack[i].state != GraphWalkerState.State.OBJECT || this.stack[i].value != o) continue;
            return true;
        }
        return false;
    }

    @Pure
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized GraphWalkerState<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> current() {
        return this.relativeFromCurrent(0);
    }

    @Pure
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized GraphWalkerState<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> relativeFromCurrent(@UnknownKeyFor @NonNull @Initialized int offset) {
        assert (this.stackSize > 0 + offset) : "Illegal State. No more element in stack";
        return this.stack[this.stackSize - (offset + 1)];
    }

    void replaceCurrent(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized GraphWalkerState<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> newState) {
        assert (this.stackSize > 0) : "Cant replace current when stack is empty";
        this.stack[this.stackSize - 1] = newState;
    }

    void pushOnStack(@Nullable @UnknownKeyFor @Initialized Object o, @UnknownKeyFor @NonNull @Initialized GraphWalkerState.State state) {
        this.pushOnStack(new GraphWalkerState<Object>(state, o));
    }

    void pushOnStack(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized GraphWalkerState<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state) {
        if (this.stackSize == this.stack.length) {
            this.grow(this.stackSize + 1);
        }
        this.stack[this.stackSize] = state;
        ++this.stackSize;
    }

    private void grow(@UnknownKeyFor @NonNull @Initialized int minCapacity) {
        int oldCapacity = this.stack.length;
        int newCapacity = Math.max(oldCapacity + oldCapacity >> 1, minCapacity);
        this.stack = Arrays.copyOf(this.stack, newCapacity);
    }

    void resetControl() {
        assert (this.control != Control.STOP) : "Should never try to continue after stop.";
        this.control = Control.CONTINUE;
    }

    @Pure
    @UnknownKeyFor @NonNull @Initialized boolean isDone() {
        return this.stackSize == 0 || this.control == Control.STOP;
    }

    @Pure
    @UnknownKeyFor @NonNull @Initialized boolean isStopped() {
        return this.control == Control.STOP;
    }

    @Pure
    @UnknownKeyFor @NonNull @Initialized boolean isDontGoDeeper() {
        return this.control == Control.STOP || this.control == Control.CONTINUE_BUT_DONT_GO_DEEPER;
    }

    @Pure
    @UnknownKeyFor @NonNull @Initialized boolean isDontGoSuper() {
        return this.control == Control.STOP || this.control == Control.CONTINUE_BUT_DONT_GO_SUPER;
    }

    void leave() {
        GraphWalkerState<?> state;
        this.goBack();
        if (!this.isDone() && (state = this.current()) != null) {
            state.leave();
        }
    }

    static enum Control {
        STOP,
        CONTINUE,
        CONTINUE_BUT_DONT_GO_DEEPER,
        CONTINUE_BUT_DONT_GO_SUPER;

    }

    public static class VisitController {
        @NotOnlyInitialized
        private final @UnknownKeyFor @NonNull @Initialized GraphWalkerContext ctx;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="We always want the current ctx.")
        VisitController(@UnderInitialization @UnknownKeyFor @NonNull GraphWalkerContext ctx) {
            this.ctx = ctx;
        }

        public void stop() {
            this.ctx.control = Control.STOP;
        }
    }
}

