package de.serra.graph_walker;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

class GraphWalkerClassState extends GraphWalkerState<Object> {
	private Class<?> positionInClassHierarchy;
	private boolean isUpwardsInClassHierarchy;
	private boolean fieldsDone;

	GraphWalkerClassState(Object value) {
		super(State.CLASS, value);
		positionInClassHierarchy = value.getClass();
	}

	@Pure
	public Class<?> getPositionInClassHierarchy() {
		return positionInClassHierarchy;
	}

	@Pure
	public boolean isUpwardsInClassHierarchy() {
		return isUpwardsInClassHierarchy;
	}

	void fieldsDone() {
		fieldsDone = true;
	}

	@Pure
	boolean fieldsAlreadyVisited() {
		return fieldsDone;
	}

	boolean tryGoUpInClassHierarchy() {
		@Nullable
		Class<?> superClass = positionInClassHierarchy.getSuperclass();
		if (superClass != null) {
			positionInClassHierarchy = superClass;
			isUpwardsInClassHierarchy = true;
			fieldsDone = false;
			return true;
		}
		return false;
	}
}
