/*
 * Decompiled with CFR 0.152.
 */
package de.serra.graph_walker;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

class GraphWalkerState<@UnknownKeyFor V> {
    final @UnknownKeyFor @NonNull @Initialized State state;
    final V value;
    private @UnknownKeyFor @NonNull @Initialized Direction direction = Direction.ENTERING;

    GraphWalkerState(@UnknownKeyFor @NonNull @Initialized State state, V value) {
        this.value = value;
        this.state = state;
    }

    public void leave() {
        assert (this.direction == Direction.ENTERING) : "Already leaving";
        this.direction = Direction.LEAVING;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean isLeaving() {
        return this.direction == Direction.LEAVING;
    }

    protected void resetDirection() {
        this.direction = Direction.ENTERING;
    }

    static enum Direction {
        ENTERING,
        LEAVING;

    }

    static enum State {
        OBJECT,
        ARRAY,
        ARRAY_MEMBER,
        CLASS,
        CLASS_FIELD;

    }
}

