package de.serra.graph_walker;

import org.checkerframework.dataflow.qual.Pure;

class GraphWalkerState<V> {
	final State state;
	final V value;
	private Direction direction = Direction.ENTERING;

	GraphWalkerState(final State state, final V value) {
		this.value = value;
		this.state = state;
	}

	enum State {
		OBJECT, ARRAY, ARRAY_MEMBER, CLASS, CLASS_FIELD;
	}

	enum Direction {
		ENTERING, LEAVING;
	}

	void leave() {
		assert direction == Direction.ENTERING : "Already leaving";

		direction = Direction.LEAVING;
	}

	@Pure
	boolean isLeaving() {
		return direction == Direction.LEAVING;
	}

	protected void resetDirection() {
		direction = Direction.ENTERING;
	}
}
