package de.serra.graph_walker;

import de.serra.graph_walker.GraphWalkerContext.Control;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;

/**
 * Allows to control the traversal.
 *
 * @author Peter Lamby
 */
public class VisitController {
	private final @NotOnlyInitialized GraphWalkerContext ctx;

	@SuppressFBWarnings(
			value = "EI_EXPOSE_REP2",
			justification = "We always want the current ctx.")
	VisitController(@UnderInitialization GraphWalkerContext ctx) {
		this.ctx = ctx;
	}

	/**
	 * Immediatly stop the traversal. No more visit methods will be called.
	 */
	public void stop() {
		ctx.control = Control.STOP;
	}

	/**
	 * Don't visit any children of the current value.
	 */
	public void dontGoDeeper() {
		ctx.control = Control.CONTINUE_BUT_DONT_GO_DEEPER;
	}
}
