package de.serra.graph_walker;

/**
 * Allows to control the traversal.
 *
 * @author Peter Lamby
 */
public abstract class VisitController {
	/**
	 * Constructs.
	 */
	protected VisitController() {
	}

	/**
	 * Immediatly stop the traversal. No more visit methods will be called.
	 */
	public abstract void stop();

	/**
	 * Don't visit any children of the current value.
	 */
	public abstract void dontGoDeeper();
}
