package de.serra.so_dirty.sn;

import java.util.Collection;
import java.util.Map;

/**
 * The default Factory that is used.
 *
 * @author Peter Lamby
 */
public class DefaultSnapshotNodeFactory extends CompoundSnapshotNodeFactory {
	/**
	 * Singleton for the default factory.
	 */
	public static final DefaultSnapshotNodeFactory INSTANCE = DefaultSnapshotNodeFactory.create();

	/**
	 * Constructs.
	 * <p>
	 * Don't use this. Use {@link DefaultSnapshotNodeFactory#create()} instead.
	 * <p>
	 * Private to avoid partial initialization.
	 *
	 * @see DefaultSnapshotNodeFactory#create()
	 */
	private DefaultSnapshotNodeFactory() {
		super();
	}

	private static DefaultSnapshotNodeFactory create() {
		final var ret = new DefaultSnapshotNodeFactory();

		final IgnoreSnapshotNodeFactory ignoreFactory = new IgnoreSnapshotNodeFactory();
		ignoreFactory.add(Collection.class, true);
		ignoreFactory.add(Map.class, true);
		ret.add(ignoreFactory);
		ret.add(new ReferenceSnapshotNodeFactory());
		ret.add(new ClassSnapshotNodeFactory(ret));
		ret.add(new ArraySnapshotNodeFactory(ret));

		return ret;
	}
}
