/*
 * Decompiled with CFR 0.152.
 */
package de.serra.so_dirty.difference;

import de.serra.so_dirty.difference.DifferenceType;
import de.serra.so_dirty.difference.DifferenceVisit;
import de.serra.so_dirty.difference.visit.CollectDifferencesVisitor;
import de.serra.so_dirty.difference.visit.DifferenceVisitor;
import de.serra.so_dirty.difference.visit.GetChildVisitor;
import de.serra.so_dirty.difference.visit.IsDifferentVisitor;
import de.serra.so_dirty.util.PathUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface DifferenceNode
extends Iterable<DifferenceNode> {
    public <T> T visit(@UnknownKeyFor @NonNull @Initialized DifferenceVisitor<T> var1, @UnknownKeyFor @NonNull @Initialized DifferenceVisit<T> var2);

    public @UnknownKeyFor @NonNull @Initialized String getName();

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DifferenceType> getTypes();

    default public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DifferenceType> getTypesRecursive() {
        EnumSet<DifferenceType> sharedState = EnumSet.noneOf(DifferenceType.class);
        return this.visit(new CollectDifferencesVisitor(sharedState), new DifferenceVisit<EnumSet<DifferenceType>>(sharedState));
    }

    default public @UnknownKeyFor @NonNull @Initialized DifferenceNode get(@UnknownKeyFor @NonNull @Initialized String path) {
        if (path.isBlank()) {
            return new EmptyDifferenceNode(path);
        }
        Object absolutPath = path.startsWith(".") ? path : "." + path;
        return this.visit(new GetChildVisitor((String)absolutPath), new DifferenceVisit<EmptyDifferenceNode>(new EmptyDifferenceNode(PathUtil.getLastPart((String)absolutPath))));
    }

    public @Nullable @UnknownKeyFor @Initialized DifferenceNode getChildNullable(@UnknownKeyFor @NonNull @Initialized String var1);

    default public @UnknownKeyFor @NonNull @Initialized DifferenceNode getChild(@UnknownKeyFor @NonNull @Initialized String childName) {
        DifferenceNode child = this.getChildNullable(childName);
        return child != null ? child : new EmptyDifferenceNode(childName);
    }

    default public @UnknownKeyFor @NonNull @Initialized boolean isDifferent(DifferenceType ... types) {
        if (types == null) {
            return !this.getTypes().isEmpty();
        }
        if (types.length == 0) {
            return false;
        }
        return !Collections.disjoint(this.getTypes(), Arrays.asList(types));
    }

    default public @UnknownKeyFor @NonNull @Initialized boolean isDifferent(@UnknownKeyFor @NonNull @Initialized String path, DifferenceType ... types) {
        return this.getChild(path).isDifferent(types);
    }

    default public @UnknownKeyFor @NonNull @Initialized boolean isDifferentRecursive(DifferenceType ... types) {
        if (types != null && types.length == 0) {
            return false;
        }
        return this.visit(new IsDifferentVisitor(types), new DifferenceVisit<Boolean>(Boolean.FALSE));
    }

    public static class EmptyDifferenceNode
    implements DifferenceNode {
        private final @UnknownKeyFor @NonNull @Initialized String name;

        public EmptyDifferenceNode(@UnknownKeyFor @NonNull @Initialized String name) {
            this.name = name;
        }

        @Override
        public <T> T visit(@UnknownKeyFor @NonNull @Initialized DifferenceVisitor<T> visitor, @UnknownKeyFor @NonNull @Initialized DifferenceVisit<T> visit) {
            visitor.visitDifferenceNode(this, visit.appendPathPrefix(this.name), visit);
            return visit.value();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized DifferenceNode> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.name;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DifferenceType> getTypes() {
            return Collections.emptySet();
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized DifferenceNode getChildNullable(@UnknownKeyFor @NonNull @Initialized String name) {
            return null;
        }
    }
}

