package de.serra.so_dirty.difference;

import de.serra.so_dirty.difference.visit.DifferenceVisitor;

import org.checkerframework.checker.nullness.qual.Nullable;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;

/**
 * A {@link DifferenceNode} with no child nodes.
 *
 * @author Peter Lamby
 */
public class LeafDifferenceNode implements DifferenceNode {
	private final String name;
	private final @Nullable Set<DifferenceType> types;

	/**
	 * Constructs.
	 *
	 * @param path  The relative path of this difference.
	 * @param types The types of difference for this node. Can be {@code null}.
	 */
	public LeafDifferenceNode(final String path, final DifferenceType @Nullable... types) {
		this.name = path;
		if (types == null || types.length == 0) {
			this.types = null;
		} else {
			this.types = EnumSet.noneOf(DifferenceType.class);
			this.types.addAll(Arrays.asList(types));
		}
	}

	@Override
	public <T> T visit(DifferenceVisitor<T> visitor, DifferenceVisit<T> visit) {
		visitor.visitDifferenceNode(this, visit.appendPathPrefix(name), visit);
		return visit.value();
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("SingleDifference [path=").append(name).append(']');
		return builder.toString();
	}

	@Override
	public Set<DifferenceType> getTypes() {
		return types == null ? Collections.emptySet() : Collections.unmodifiableSet(types);
	}

	@Override
	public @Nullable DifferenceNode getChildNullable(String name) {
		return null;
	}

	@Override
	public Iterator<DifferenceNode> iterator() {
		return Collections.emptyIterator();
	}
}
