/*
 * Decompiled with CFR 0.152.
 */
package de.serra.so_dirty.sn;

import de.serra.so_dirty.sn.ArraySnapshotNode;
import de.serra.so_dirty.sn.SnapshotNode;
import de.serra.so_dirty.sn.SnapshotNodeFactory;
import java.lang.reflect.Array;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ArraySnapshotNodeFactory
implements SnapshotNodeFactory {
    private final @UnknownKeyFor @NonNull @Initialized SnapshotNodeFactory memberFactory;

    public ArraySnapshotNodeFactory(@UnknownKeyFor @NonNull @Initialized SnapshotNodeFactory memberFactory) {
        this.memberFactory = memberFactory;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean supports(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type) {
        return type.isArray() && !type.isSynthetic() && this.memberFactory.supports(type.getComponentType());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ArraySnapshotNode toSnapshotNode(@UnknownKeyFor @NonNull @Initialized Object value) {
        @Nullable SnapshotNode[] memberNodes = new SnapshotNode[Array.getLength(value)];
        for (int i = 0; i < Array.getLength(value); ++i) {
            Object currentValue = Array.get(value, i);
            memberNodes[i] = currentValue != null && this.memberFactory.supports(currentValue.getClass()) ? this.memberFactory.toSnapshotNode(currentValue) : null;
        }
        return new ArraySnapshotNode(value, memberNodes);
    }
}

