/*
 * Decompiled with CFR 0.152.
 */
package de.serra.so_dirty.sn;

import de.serra.so_dirty.difference.DifferenceNode;
import de.serra.so_dirty.difference.DifferenceType;
import de.serra.so_dirty.difference.LeafDifferenceNode;
import de.serra.so_dirty.difference.MapDifferenceNode;
import de.serra.so_dirty.sn.SnapshotNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MapSnapshotNode
implements SnapshotNode {
    private final @UnknownKeyFor @NonNull @Initialized Object value;
    private final @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized MapMemberSnapshotNode> entries;

    public MapSnapshotNode(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized MapMemberSnapshotNode> entries) {
        this.value = value;
        this.entries = new ArrayList<MapMemberSnapshotNode>(entries);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object value() {
        return this.value;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DifferenceNode diff(@Nullable @UnknownKeyFor @Initialized SnapshotNode other, @UnknownKeyFor @NonNull @Initialized String path) {
        EnumSet<DifferenceType> diffTypes = EnumSet.noneOf(DifferenceType.class);
        if (other == null || !Objects.equals(this.value, other.value())) {
            diffTypes.add(DifferenceType.EQUALITY);
        }
        if (other == null || this.value != other.value()) {
            diffTypes.add(DifferenceType.REFERENCE);
        }
        if (other == null || !Objects.equals(this.value.getClass(), other.value().getClass())) {
            diffTypes.add(DifferenceType.TYPE_CHANGE);
        }
        if (!(other instanceof MapSnapshotNode)) {
            return new LeafDifferenceNode(path, (DifferenceType[])diffTypes.toArray(DifferenceType[]::new));
        }
        MapSnapshotNode them = (MapSnapshotNode)other;
        int foundEntries = 0;
        int removedKeys = 0;
        int addedKeys = 0;
        HashMap<@Nullable Object, DifferenceNode> differences = new HashMap<Object, DifferenceNode>();
        for (int i = 0; i < this.entries.size(); ++i) {
            MapMemberSnapshotNode oldEntry = this.entries.get(i);
            @Nullable SnapshotNode oldKey = oldEntry.keySnapshot;
            @Nullable MapMemberSnapshotNode newEntry = this.findByKey(oldKey == null ? null : oldKey.value(), them.entries);
            if (newEntry == null) {
                --removedKeys;
                diffTypes.add(DifferenceType.KEY_REMOVED);
                continue;
            }
            ++foundEntries;
            String mapIdx = "[" + i + "]";
            DifferenceNode valueDiff = SnapshotNode.doDiff(oldEntry.valueSnapshot, newEntry.valueSnapshot, mapIdx);
            if (!valueDiff.isDifferent((DifferenceType[])null)) continue;
            differences.put(oldKey == null ? null : oldKey.value(), valueDiff);
        }
        if (foundEntries < them.entries.size()) {
            diffTypes.add(DifferenceType.KEY_ADDED);
            for (MapMemberSnapshotNode newEntry : them.entries) {
                SnapshotNode newKey = newEntry.keySnapshot;
                if (this.findByKey(newKey == null ? null : newKey.value(), this.entries) != null) continue;
                ++addedKeys;
            }
            assert (addedKeys > 0) : "we didn't find all entries but also could not determin the new ones";
        }
        return new MapDifferenceNode(path, diffTypes, removedKeys, addedKeys, differences);
    }

    private @Nullable @UnknownKeyFor @Initialized MapMemberSnapshotNode findByKey(@Nullable @UnknownKeyFor @Initialized Object needle, @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized MapMemberSnapshotNode> hayball) {
        for (MapMemberSnapshotNode curr : hayball) {
            if (!(curr.keySnapshot == null ? needle == null : Objects.equals(needle, curr.keySnapshot.value()))) continue;
            return curr;
        }
        return null;
    }

    public static class MapMemberSnapshotNode {
        public final @Nullable @UnknownKeyFor @Initialized SnapshotNode keySnapshot;
        public final @Nullable @UnknownKeyFor @Initialized SnapshotNode valueSnapshot;

        public MapMemberSnapshotNode(@Nullable @UnknownKeyFor @Initialized SnapshotNode keySnapshot, @Nullable @UnknownKeyFor @Initialized SnapshotNode valueSnapshot) {
            this.keySnapshot = keySnapshot;
            this.valueSnapshot = valueSnapshot;
        }
    }
}

