package de.serra.so_dirty.difference.visit;

import de.serra.so_dirty.difference.DifferenceNode;
import de.serra.so_dirty.difference.DifferenceType;
import de.serra.so_dirty.difference.DifferenceVisit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

import java.util.Set;

/**
 * Collects all the {@link DifferenceType}s.
 *
 * @author Peter Lamby
 */
public class CollectDifferencesVisitor implements DifferenceVisitor<Set<DifferenceType>> {
	private final Set<DifferenceType> state;

	/**
	 * Constructs.
	 * <p>
	 * The {@code sharedState} should also be used to initialize the {@link DifferenceVisit}.
	 *
	 * @param sharedState The state shared with the visit.
	 */
	@SuppressFBWarnings(
			value = "EI_EXPOSE_REP2",
			justification = "We do this to share the state with visit")
	public CollectDifferencesVisitor(final Set<DifferenceType> sharedState) {
		this.state = sharedState;
	}

	@Override
	public void visitDifferenceNode(DifferenceNode node, String path, DifferenceVisit<Set<DifferenceType>> visit) {
		state.addAll(node.getTypes());

		// we can stop now. There is nothing to gain anymore.
		if (state.size() == DifferenceType.values().length) {
			visit.stop(state);
		}
	}
}
