package de.serra.so_dirty.sn;

import org.checkerframework.checker.nullness.qual.Nullable;

import java.lang.reflect.Array;

/**
 * Factory that creates an {@link ArraySnapshotNode}.
 *
 * @author Peter Lamby
 */
public class ArraySnapshotNodeFactory implements SnapshotNodeFactory {
	private final SnapshotNodeFactory memberFactory;

	/**
	 * Constructs.
	 * <p>
	 * Uses {@code memberFactory} to create {@link SnapshotNode}s for the elements of the array.
	 *
	 * @param memberFactory The factory to use for the elements of the array.
	 */
	public ArraySnapshotNodeFactory(final SnapshotNodeFactory memberFactory) {
		this.memberFactory = memberFactory;
	}

	@Override
	public boolean supports(final Class<?> type) {
		return type.isArray() && !type.isSynthetic() && memberFactory.supports(type.getComponentType());
	}

	@Override
	public ArraySnapshotNode toSnapshotNode(final Object value) {
		final @Nullable SnapshotNode[] memberNodes = new SnapshotNode[Array.getLength(value)];
		for (int i = 0; i < Array.getLength(value); i++) {
			final var currentValue = Array.get(value, i);
			if (currentValue != null && memberFactory.supports(currentValue.getClass())) {
				memberNodes[i] = memberFactory.toSnapshotNode(currentValue);
			} else {
				memberNodes[i] = null;
			}
		}
		return new ArraySnapshotNode(value, memberNodes);
	}
}
