package de.serra.so_dirty.sn;

import de.serra.so_dirty.difference.DifferenceNode;
import de.serra.so_dirty.difference.DifferenceType;
import de.serra.so_dirty.difference.LeafDifferenceNode;

import org.checkerframework.checker.nullness.qual.Nullable;

import java.util.EnumSet;
import java.util.Objects;

import static de.serra.so_dirty.difference.DifferenceType.EQUALITY;
import static de.serra.so_dirty.difference.DifferenceType.REFERENCE;
import static de.serra.so_dirty.difference.DifferenceType.TYPE_CHANGE;

/**
 * Can diff an {@link SnapshotNode} by {@link DifferenceType#REFERENCE}, {@link DifferenceType#EQUALITY} and
 * {@link DifferenceType#TYPE_CHANGE}. Does not check any members.
 *
 * @author Peter Lamby
 */
public class ReferenceSnapshotNode implements SnapshotNode {
	private final Object value;

	/**
	 * Constructs
	 *
	 * @param value The instance to snapshot.
	 */
	public ReferenceSnapshotNode(final Object value) {
		this.value = value;
	}

	@Override
	public Object value() {
		return value;
	}

	@Override
	public DifferenceNode diff(final @Nullable SnapshotNode other, final String path) {
		final var diffTypes = EnumSet.noneOf(DifferenceType.class);
		if (other == null || !Objects.equals(value, other.value())) {
			diffTypes.add(EQUALITY);
			diffTypes.add(REFERENCE); // don't use == here since we don't properly handle primitives for now.
		}
		if (other == null || !Objects.equals(value.getClass(), other.value().getClass())) {
			diffTypes.add(TYPE_CHANGE);
		}

		return new LeafDifferenceNode(path, diffTypes.toArray(DifferenceType[]::new));
	}
}
