/*
 * Decompiled with CFR 0.152.
 */
package de.serra.so_dirty.difference;

import de.serra.so_dirty.difference.DifferenceNode;
import de.serra.so_dirty.difference.DifferenceType;
import de.serra.so_dirty.difference.DifferenceVisit;
import de.serra.so_dirty.difference.visit.DifferenceVisitor;
import de.serra.so_dirty.util.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DifferenceNodes
implements DifferenceNode {
    private final @UnknownKeyFor @NonNull @Initialized String name;
    private final @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized DifferenceType> types;
    private final @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DifferenceNode> pathsToDifferences = new HashMap();
    private final @Nullable @UnknownKeyFor @Initialized Character pathSeparator;

    public DifferenceNodes(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Character pathSeparator, DifferenceType ... types) {
        this.name = name;
        this.pathSeparator = pathSeparator;
        if (types == null || types.length == 0) {
            this.types = null;
        } else {
            this.types = EnumSet.noneOf(DifferenceType.class);
            this.types.addAll(Arrays.asList(types));
        }
    }

    public DifferenceNodes(@UnknownKeyFor @NonNull @Initialized String name, DifferenceType ... types) {
        this(name, (Character)null, types);
    }

    @Override
    public <T> T visit(@UnknownKeyFor @NonNull @Initialized DifferenceVisitor<T> visitor, @UnknownKeyFor @NonNull @Initialized DifferenceVisit<T> visit) {
        visitor.visitDifferenceNode(this, visit.appendPathPrefix(this.name), visit);
        if (visit.isDontGoDeeper()) {
            return visit.value();
        }
        CharSequence currentPath = this.pathSeparator != null && visit.pathPrefix().charAt(visit.pathPrefix().length() - 1) != this.pathSeparator.charValue() ? new StringBuilder(visit.pathPrefix()).append(this.pathSeparator.charValue()) : visit.pathPrefix();
        for (DifferenceNode child : this) {
            DifferenceVisit<T> childTraversal = new DifferenceVisit<T>(visit.value(), currentPath);
            child.visit(visitor, childTraversal);
            if (!childTraversal.isStopped()) continue;
            visit.stop(childTraversal.value());
            break;
        }
        return visit.value();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.name;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DifferenceType> getTypes() {
        return this.types == null ? Collections.emptySet() : Collections.unmodifiableSet(this.types);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized DifferenceNode getChildNullable(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.pathsToDifferences.get(name);
    }

    public void add(@UnknownKeyFor @NonNull @Initialized DifferenceNode difference) {
        if (this.pathsToDifferences.put(difference.getName(), difference) != null) {
            throw new IllegalStateException("Trying to add a difference for the same path twice");
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized DifferenceNode> iterator() {
        return new UnmodifiableIterator<DifferenceNode>(this.pathsToDifferences.values().iterator());
    }
}

