package de.serra.so_dirty.difference;

/**
 * The kind of difference.
 * <p>
 * What this means is different depending on what is being compared. In this Table {@code then} and {@code now} is used
 * to describe the object in the past and present:
 *
 * <table>
 * <caption>The meaning of {@link DifferenceType}</caption> <thead>
 * <tr>
 * <th>{@link de.serra.so_dirty.sn.SnapshotNode SnapshotNode} type</th>
 * <th>{@link DifferenceType#REFERENCE}</th>
 * <th>{@link DifferenceType#EQUALITY}</th>
 * <th>{@link DifferenceType#TYPE_CHANGE}</th>
 * <th>{@link DifferenceType#KEY_ADDED}</th>
 * <th>{@link DifferenceType#KEY_REMOVED}</th>
 * </tr>
 * </thead> <tbody>
 * <tr>
 * <th scope="row">Any different sub classes of {@link de.serra.so_dirty.sn.SnapshotNode}</th>
 * <td>Always</td>
 * <td>Always</td>
 * <td>Always</td>
 * </tr>
 * <tr>
 * <th scope="row">{@link de.serra.so_dirty.sn.ReferenceSnapshotNode}</th>
 * <td>
 * {@snippet lang = "java" :
 * !then.equals(now)
 * }
 * </td>
 * <td>
 * {@snippet lang = "java" :
 * !then.equals(now)
 * }
 * </td>
 * <td>
 * {@snippet lang = "java" :
 * !then.getClass().equals(now.getClass())
 * }
 * </td>
 * <td>never</td>
 * <td>never</td>
 * </tr>
 * <tr>
 * <th scope="row">{@link de.serra.so_dirty.sn.ArraySnapshotNode}</th>
 * <td>
 * {@snippet lang = "java" :
 * then != now
 * }
 * </td>
 * <td>
 * {@snippet lang = "java" :
 * !then.equals(now)
 * }
 * </td>
 * <td>
 * {@snippet lang = "java" :
 * !then.getClass().getComponentType().equals(now.getClass().getComponentType())
 * }
 * </td>
 * <td>never</td>
 * <td>never</td>
 * </tr>
 * <tr>
 * <th scope="row">{@link de.serra.so_dirty.sn.ClassSnapshotNode}</th>
 * <td>
 * {@snippet lang = "java" :
 * !then != now
 * }
 * </td>
 * <td>
 * {@snippet lang = "java" :
 * !then.equals(now)
 * }
 * </td>
 * <td>
 * {@snippet lang = "java" :
 * !then.getClass().equals(now.getClass())
 * }
 * </td>
 * <td>never</td>
 * <td>never</td>
 * </tr>
 * <tr>
 * <th scope="row">{@link de.serra.so_dirty.sn.MapSnapshotNode}</th>
 * <td>
 * {@snippet lang = "java" :
 * !then != now
 * }
 * </td>
 * <td>
 * {@snippet lang = "java" :
 * !then.equals(now)
 * }
 * </td>
 * <td>
 * {@snippet lang = "java" :
 * !then.getClass().equals(now.getClass())
 * }
 * </td>
 * <td>
 * {@snippet lang = "java" :
 * for (var nowKey : now.keySet()) {
 * 	if (!then.containsKey(nowKey)) {
 * 		return true;
 * 	}
 * }
 * return false;
 * }
 * </td>
 * <td>
 * {@snippet lang = "java" :
 * for (var thenKey : then.keySet()) {
 * 	if (!now.containsKey(thenKey)) {
 * 		return true;
 * 	}
 * }
 * return false;
 * }
 * </td>
 * </tr>
 * </tbody>
 * </table>
 *
 * In addition to the table there are some special cases:
 * <p>
 * {@code null} diffed against a non {@code null} value is always all three difference types. {@code null} diffed
 * against {@code null} is always none of the difference types.
 *
 * @author Peter Lamby
 */
public enum DifferenceType {
	/**
	 * The value is different by reference (==).
	 */
	REFERENCE,
	/**
	 * The value is different by equality ({@link Object#equals(Object)}.
	 */
	EQUALITY,
	/**
	 * The class of the value changed. This always implies {@link DifferenceType#REFERENCE}.
	 */
	TYPE_CHANGE,
	/**
	 * A key was found in a {@link java.util.Map Map} that was not there in the previous snapshot.
	 * <p>
	 * The keys are compared by {@link Object#equals(Object) equality}.
	 */
	KEY_ADDED,
	/**
	 * A key that was previously in a {@link java.util.Map Map} is not there anymore.
	 * <p>
	 * The keys are compared by {@link Object#equals(Object) equality}.
	 */
	KEY_REMOVED;
}
