/*
 * Decompiled with CFR 0.152.
 */
package de.serra.so_dirty.util;

import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public final class PathUtil {
    private PathUtil() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String getLastPart(@UnknownKeyFor @NonNull @Initialized String pathExpression) {
        if (pathExpression.isEmpty()) {
            return pathExpression;
        }
        char[] chars = pathExpression.toCharArray();
        StringBuilder buf = new StringBuilder();
        for (int i = chars.length - 1; i >= 0; --i) {
            char c = chars[i];
            if (c == '.') {
                return buf.length() == 0 ? "." : buf.reverse().toString();
            }
            if (c == ']') {
                if (buf.length() != 0) {
                    return buf.reverse().toString();
                }
                boolean found = false;
                --i;
                while (i >= 0) {
                    c = chars[i];
                    if (c == '[') {
                        found = true;
                        break;
                    }
                    buf.append(c);
                    --i;
                }
                if (!found) {
                    throw new IllegalArgumentException("Found ']' without a matching '['.");
                }
                if (buf.length() == 0) {
                    throw new IllegalArgumentException("Found an empty index expression.");
                }
                return "[" + String.valueOf(buf.reverse()) + "]";
            }
            if (c == '[') {
                throw new IllegalArgumentException("Found '[' without a matching ']'.");
            }
            buf.append(c);
        }
        return buf.reverse().toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized FirstPart getFirstPart(@UnknownKeyFor @NonNull @Initialized String pathExpression) {
        if (pathExpression.isEmpty()) {
            return new FirstPart(pathExpression);
        }
        char[] chars = pathExpression.toCharArray();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '.') {
                if (buf.length() == 0) {
                    return new FirstPart(".", PathUtil.getTail(chars, ++i));
                }
                return new FirstPart(buf.toString(), PathUtil.getTail(chars, ++i));
            }
            if (c == '[') {
                if (buf.length() != 0) {
                    return new FirstPart(buf.toString(), PathUtil.getTail(chars, i));
                }
                boolean found = false;
                ++i;
                while (i < chars.length) {
                    c = chars[i];
                    if (c == ']') {
                        found = true;
                        break;
                    }
                    buf.append(c);
                    ++i;
                }
                if (!found) {
                    throw new IllegalArgumentException("Found '[' without a matching ']'.");
                }
                if (buf.length() == 0) {
                    throw new IllegalArgumentException("Found an empty index expression.");
                }
                if (i + 1 < chars.length && chars[i + 1] == '.') {
                    ++i;
                }
                return new FirstPart("[" + String.valueOf(buf) + "]", PathUtil.getTail(chars, ++i));
            }
            if (c == ']') {
                throw new IllegalArgumentException("Found ']' without a matching '['.");
            }
            buf.append(c);
        }
        return new FirstPart(buf.toString());
    }

    public static @Nullable @UnknownKeyFor @Initialized String getTail(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chars, @UnknownKeyFor @NonNull @Initialized int offset) {
        if (offset >= chars.length) {
            return null;
        }
        return new String(chars, offset, chars.length - offset);
    }

    public static class FirstPart {
        public final @UnknownKeyFor @NonNull @Initialized String firstPart;
        public final @Nullable @UnknownKeyFor @Initialized String rest;

        public FirstPart(@UnknownKeyFor @NonNull @Initialized String firstPart, @Nullable @UnknownKeyFor @Initialized String rest) {
            this.firstPart = firstPart;
            this.rest = rest;
        }

        public FirstPart(@UnknownKeyFor @NonNull @Initialized String firstPart) {
            this(firstPart, null);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.firstPart, this.rest);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FirstPart other = (FirstPart)obj;
            return Objects.equals(this.firstPart, other.firstPart) && Objects.equals(this.rest, other.rest);
        }
    }
}

