package de.serra.so_dirty.difference.visit;

import de.serra.so_dirty.difference.DifferenceNode;
import de.serra.so_dirty.difference.DifferenceVisit;

/**
 * Visitor that returns the {@link DifferenceNode} at the specified {@link #path}.
 *
 * @author Peter Lamby
 */
public class GetChildVisitor implements DifferenceVisitor<DifferenceNode> {
	private String path;

	/**
	 * Constructs.
	 *
	 * @param path The path of the node that should be returned.
	 */
	public GetChildVisitor(String path) {
		this.path = path;
	}

	@Override
	public void visitDifferenceNode(DifferenceNode node, String path, DifferenceVisit<DifferenceNode> visit) {
		if (this.path.startsWith(path)) {
			if (this.path.length() == path.length()) {
				visit.stop(node);
			}
		} else {
			visit.dontGoDeeper();
		}
	}
}
