package de.serra.so_dirty.difference.visit;

import de.serra.so_dirty.difference.DifferenceNode;
import de.serra.so_dirty.difference.DifferenceType;
import de.serra.so_dirty.difference.DifferenceVisit;

import org.checkerframework.checker.nullness.qual.Nullable;

import static java.lang.Boolean.TRUE;

/**
 * Visitor that checks if the node or it's children are different in at least one of {@code #types}.
 * <p>
 * If {@code types} is {@code null} it checks for any difference.
 */
public class IsDifferentVisitor implements DifferenceVisitor<Boolean> {
	private final DifferenceType @Nullable [] types;

	/**
	 * Constructs.
	 *
	 * @param types The types of difference to check for.
	 */
	public IsDifferentVisitor(final DifferenceType @Nullable... types) {
		this.types = types;
	}

	@Override
	public void visitDifferenceNode(DifferenceNode node, String path, DifferenceVisit<Boolean> visit) {
		if (node.isDifferent(types)) {
			visit.stop(TRUE);
		}
	}
}
