package de.serra.so_dirty.sn;

import org.checkerframework.checker.nullness.qual.Nullable;

import java.util.ArrayList;
import java.util.Map;

/**
 * Factory that creates an {@link MapSnapshotNode}.
 * <p>
 * Experimental and not fully fleshed out.
 *
 * @author Peter Lamby
 */
public class MapSnapshotNodeFactory implements SnapshotNodeFactory {
	private final SnapshotNodeFactory keyAndValueFactory;

	/**
	 * Constructs.
	 *
	 * @param keyAndValueFactory The factory to use for the keys and values of the map.
	 */
	public MapSnapshotNodeFactory(final SnapshotNodeFactory keyAndValueFactory) {
		this.keyAndValueFactory = keyAndValueFactory;
	}

	@Override
	public boolean supports(final Class<?> type) {
		return Map.class.isAssignableFrom(type) && !type.isSynthetic();
	}

	@Override
	public MapSnapshotNode toSnapshotNode(final Object value) {
		final Map<?, ?> map = (Map<?, ?>) value;
		final ArrayList<MapSnapshotNode.MapMemberSnapshotNode> entries = new ArrayList<>(map.size());
		for (final var entry : map.entrySet()) {
			final var currentKey = entry.getKey();
			final var currentValue = entry.getValue();

			final @Nullable SnapshotNode keySnapshot = currentKey == null ? null
					: !keyAndValueFactory.supports(currentKey.getClass()) ? new ReferenceSnapshotNode(currentKey)
							: keyAndValueFactory.toSnapshotNode(currentKey);
			final @Nullable SnapshotNode valueSnapshot = currentValue == null ? null
					: !keyAndValueFactory.supports(currentValue.getClass()) ? new ReferenceSnapshotNode(currentValue)
							: keyAndValueFactory.toSnapshotNode(currentValue);

			entries.add(new MapSnapshotNode.MapMemberSnapshotNode(keySnapshot, valueSnapshot));
		}

		return new MapSnapshotNode(map, entries);
	}
}
