/*
 * Decompiled with CFR 0.152.
 */
package de.serra.so_dirty.difference;

import de.serra.so_dirty.difference.DifferenceNode;
import de.serra.so_dirty.difference.DifferenceType;
import de.serra.so_dirty.difference.DifferenceVisit;
import de.serra.so_dirty.difference.visit.DifferenceVisitor;
import de.serra.so_dirty.util.UnmodifiableIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MapDifferenceNode
implements DifferenceNode {
    private final @UnknownKeyFor @NonNull @Initialized String name;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DifferenceType> types;
    private final @UnknownKeyFor @NonNull @Initialized int removedKeys;
    private final @UnknownKeyFor @NonNull @Initialized int addedKeys;
    private final @UnknownKeyFor @NonNull @Initialized Map<@Nullable @UnknownKeyFor @Initialized Object, @UnknownKeyFor @NonNull @Initialized DifferenceNode> differentValues;

    @SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL"}, justification="We keep removed/added keys for now to be able to expose them as difference later on")
    public MapDifferenceNode(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized DifferenceType> types, @UnknownKeyFor @NonNull @Initialized int removedKeys, @UnknownKeyFor @NonNull @Initialized int addedKeys, @UnknownKeyFor @NonNull @Initialized Map<@Nullable @UnknownKeyFor @Initialized Object, @UnknownKeyFor @NonNull @Initialized DifferenceNode> differentValues) {
        this.name = name;
        this.types = types == null ? Collections.emptySet() : EnumSet.copyOf(types);
        this.removedKeys = removedKeys;
        this.addedKeys = addedKeys;
        this.differentValues = new HashMap<Object, DifferenceNode>(differentValues);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized DifferenceNode> iterator() {
        return new UnmodifiableIterator<DifferenceNode>(this.differentValues.values().iterator());
    }

    @Override
    public <T> T visit(@UnknownKeyFor @NonNull @Initialized DifferenceVisitor<T> visitor, @UnknownKeyFor @NonNull @Initialized DifferenceVisit<T> visit) {
        visitor.visitMapDifferenceNode(this, visit.appendPathPrefix(this.name), visit);
        if (visit.isDontGoDeeper()) {
            return visit.value();
        }
        for (DifferenceNode child : this) {
            DifferenceVisit<T> childTraversal = new DifferenceVisit<T>(visit.value(), visit.pathPrefix());
            child.visit(visitor, childTraversal);
            if (!childTraversal.isStopped()) continue;
            visit.stop(childTraversal.value());
            break;
        }
        return visit.value();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.name;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DifferenceType> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized DifferenceNode getChildNullable(@UnknownKeyFor @NonNull @Initialized String name) {
        return null;
    }
}

