/*
 * Decompiled with CFR 0.152.
 */
package de.serra.so_dirty.sn;

import de.serra.so_dirty.difference.DifferenceNode;
import de.serra.so_dirty.difference.DifferenceNodes;
import de.serra.so_dirty.difference.DifferenceType;
import de.serra.so_dirty.difference.LeafDifferenceNode;
import de.serra.so_dirty.sn.SnapshotNode;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ArraySnapshotNode
implements SnapshotNode {
    private final @UnknownKeyFor @NonNull @Initialized Object value;
    private final @Nullable @UnknownKeyFor @Initialized SnapshotNode @UnknownKeyFor @NonNull @Initialized [] nodes;

    public ArraySnapshotNode(@UnknownKeyFor @NonNull @Initialized Object value, @Nullable @UnknownKeyFor @Initialized SnapshotNode @UnknownKeyFor @NonNull @Initialized [] members) {
        this.value = value;
        this.nodes = Arrays.copyOf(members, members.length);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object value() {
        return this.value;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DifferenceNode diff(@Nullable @UnknownKeyFor @Initialized SnapshotNode other, @UnknownKeyFor @NonNull @Initialized String path) {
        EnumSet<DifferenceType> diffTypes = EnumSet.noneOf(DifferenceType.class);
        if (other == null || !Objects.equals(this.value, other.value())) {
            diffTypes.add(DifferenceType.EQUALITY);
        }
        if (other == null || this.value != other.value()) {
            diffTypes.add(DifferenceType.REFERENCE);
        }
        if (other == null || !Objects.equals(this.value.getClass(), other.value().getClass())) {
            diffTypes.add(DifferenceType.TYPE_CHANGE);
        }
        if (!(other instanceof ArraySnapshotNode)) {
            return new LeafDifferenceNode(path, (DifferenceType[])diffTypes.toArray(DifferenceType[]::new));
        }
        ArraySnapshotNode them = (ArraySnapshotNode)other;
        DifferenceNodes ret = new DifferenceNodes(path, (DifferenceType[])diffTypes.toArray(DifferenceType[]::new));
        int min = Math.min(this.nodes.length, them.nodes.length);
        if (this.nodes.length != them.nodes.length) {
            int max = Math.max(this.nodes.length, them.nodes.length);
            for (int i = min; i < max; ++i) {
                ret.add(new LeafDifferenceNode("[" + i + "]", DifferenceType.TYPE_CHANGE, DifferenceType.REFERENCE));
            }
        }
        if (min > 0) {
            for (int i = 0; i < min; ++i) {
                DifferenceNode diff;
                SnapshotNode snapshotNode = this.nodes[i];
                SnapshotNode otherSnapshotNode = them.nodes[i];
                if (snapshotNode == null && otherSnapshotNode == null || !(diff = SnapshotNode.doDiff(snapshotNode, otherSnapshotNode, "[" + i + "]")).isDifferentRecursive(null)) continue;
                ret.add(diff);
            }
        }
        return ret;
    }
}

