/*
 * Decompiled with CFR 0.152.
 */
package de.serra.so_dirty.sn;

import de.serra.so_dirty.difference.DifferenceNode;
import de.serra.so_dirty.difference.DifferenceNodes;
import de.serra.so_dirty.difference.DifferenceType;
import de.serra.so_dirty.difference.LeafDifferenceNode;
import de.serra.so_dirty.sn.SnapshotNode;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ClassSnapshotNode
implements SnapshotNode {
    private final @UnknownKeyFor @NonNull @Initialized Object value;
    private final @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @Nullable @UnknownKeyFor @Initialized SnapshotNode> fieldsToSnapshots;

    public ClassSnapshotNode(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @Nullable @UnknownKeyFor @Initialized SnapshotNode> fieldsToSnapshots) {
        this.value = value;
        this.fieldsToSnapshots = new HashMap<String, SnapshotNode>(fieldsToSnapshots);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object value() {
        return this.value;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DifferenceNode diff(@Nullable @UnknownKeyFor @Initialized SnapshotNode other, @UnknownKeyFor @NonNull @Initialized String path) {
        EnumSet<DifferenceType> diffTypes = EnumSet.noneOf(DifferenceType.class);
        if (other == null || !Objects.equals(this.value, other.value())) {
            diffTypes.add(DifferenceType.EQUALITY);
        }
        if (other == null || this.value != other.value()) {
            diffTypes.add(DifferenceType.REFERENCE);
        }
        if (other == null || !Objects.equals(this.value.getClass(), other.value().getClass())) {
            diffTypes.add(DifferenceType.TYPE_CHANGE);
        }
        if (!(other instanceof ClassSnapshotNode)) {
            return new LeafDifferenceNode(path, (DifferenceType[])diffTypes.toArray(DifferenceType[]::new));
        }
        ClassSnapshotNode them = (ClassSnapshotNode)other;
        DifferenceNodes differences = new DifferenceNodes(path, Character.valueOf('.'), (DifferenceType[])diffTypes.toArray(DifferenceType[]::new));
        for (Map.Entry<String, SnapshotNode> entry : this.fieldsToSnapshots.entrySet()) {
            DifferenceNode difference;
            SnapshotNode snapshotNode = entry.getValue();
            SnapshotNode otherSnapshotNode = them.fieldsToSnapshots.get(entry.getKey());
            if (snapshotNode == null && otherSnapshotNode == null || !(difference = SnapshotNode.doDiff(snapshotNode, otherSnapshotNode, entry.getKey())).isDifferentRecursive(null)) continue;
            differences.add(difference);
        }
        for (String key : them.fieldsToSnapshots.keySet()) {
            if (this.fieldsToSnapshots.containsKey(key)) continue;
            differences.add(new LeafDifferenceNode(key, DifferenceType.TYPE_CHANGE, DifferenceType.REFERENCE, DifferenceType.EQUALITY));
        }
        return differences;
    }
}

