package de.serra.so_dirty.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

import java.util.Iterator;

/**
 * Decorator that makes an {@link Iterator} unmodifiable.
 *
 * @author Peter Lamby
 */
public class UnmodifiableIterator<T> implements Iterator<T> {
	private final Iterator<? extends T> inner;

	/**
	 * Constructs.
	 *
	 * @param iterator The inner iterator.
	 */
	@SuppressFBWarnings(
			value = "EI_EXPOSE_REP2",
			justification = "This is fine since this is just a simple decorator that doesn't need immutability.")
	public UnmodifiableIterator(final Iterator<? extends T> iterator) {
		this.inner = iterator;
	}

	@Override
	public boolean hasNext() {
		return inner.hasNext();
	}

	@Override
	public T next() {
		return inner.next();
	}
}
