package de.serra.so_dirty.sn;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;

/**
 * Factory that creates an {@link ReferenceSnapshotNode}.
 *
 * @author Peter Lamby
 */
public class ReferenceSnapshotNodeFactory implements SnapshotNodeFactory {
	private static final HashSet<Class<?>> IMMUTABLE_TYPES;

	static {
		IMMUTABLE_TYPES = new HashSet<>();
		IMMUTABLE_TYPES.add(String.class);

		IMMUTABLE_TYPES.add(Short.class);
		IMMUTABLE_TYPES.add(Integer.class);
		IMMUTABLE_TYPES.add(Long.class);
		IMMUTABLE_TYPES.add(Byte.class);
		IMMUTABLE_TYPES.add(Character.class);
		IMMUTABLE_TYPES.add(Float.class);
		IMMUTABLE_TYPES.add(Double.class);
		IMMUTABLE_TYPES.add(Boolean.class);

		IMMUTABLE_TYPES.add(BigDecimal.class);
		IMMUTABLE_TYPES.add(BigInteger.class);

		IMMUTABLE_TYPES.add(Locale.class);
		IMMUTABLE_TYPES.add(UUID.class);

		IMMUTABLE_TYPES.add(LocalDateTime.class);
		IMMUTABLE_TYPES.add(LocalDate.class);
		IMMUTABLE_TYPES.add(LocalTime.class);
		IMMUTABLE_TYPES.add(OffsetDateTime.class);
		IMMUTABLE_TYPES.add(OffsetTime.class);
		IMMUTABLE_TYPES.add(ZonedDateTime.class);
		IMMUTABLE_TYPES.add(Instant.class);
		IMMUTABLE_TYPES.add(Duration.class);
		IMMUTABLE_TYPES.add(Period.class);
	}

	/**
	 * Constructs.
	 */
	public ReferenceSnapshotNodeFactory() {
	}

	@Override
	public boolean supports(final Class<?> type) {
		return type.isEnum() || type.isPrimitive() || IMMUTABLE_TYPES.contains(type);
	}

	@Override
	public ReferenceSnapshotNode toSnapshotNode(final Object value) {
		return new ReferenceSnapshotNode(value);
	}
}
