/*
 * Decompiled with CFR 0.152.
 */
package de.serra.so_dirty.difference;

import de.serra.so_dirty.difference.DifferenceNode;
import de.serra.so_dirty.difference.DifferenceType;
import de.serra.so_dirty.difference.DifferenceVisit;
import de.serra.so_dirty.difference.visit.DifferenceVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class LeafDifferenceNode
implements DifferenceNode {
    private final @UnknownKeyFor @NonNull @Initialized String name;
    private final @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized DifferenceType> types;

    public LeafDifferenceNode(@UnknownKeyFor @NonNull @Initialized String path, DifferenceType ... types) {
        this.name = path;
        if (types == null || types.length == 0) {
            this.types = null;
        } else {
            this.types = EnumSet.noneOf(DifferenceType.class);
            this.types.addAll(Arrays.asList(types));
        }
    }

    @Override
    public <T> T visit(@UnknownKeyFor @NonNull @Initialized DifferenceVisitor<T> visitor, @UnknownKeyFor @NonNull @Initialized DifferenceVisit<T> visit) {
        visitor.visitDifferenceNode(this, visit.appendPathPrefix(this.name), visit);
        return visit.value();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.name;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SingleDifference [path=").append(this.name).append(']');
        return builder.toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DifferenceType> getTypes() {
        return this.types == null ? Collections.emptySet() : Collections.unmodifiableSet(this.types);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized DifferenceNode getChildNullable(@UnknownKeyFor @NonNull @Initialized String name) {
        return null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized DifferenceNode> iterator() {
        return Collections.emptyIterator();
    }
}

