package de.serra.so_dirty.difference.visit;

import de.serra.so_dirty.difference.DifferenceNode;
import de.serra.so_dirty.difference.DifferenceNodes;
import de.serra.so_dirty.difference.DifferenceVisit;
import de.serra.so_dirty.difference.MapDifferenceNode;

/**
 * Visitor for {@link DifferenceNode}s.
 * <p>
 * For each node that is traversed only a single of the visit methods is called. Hoever the default implementation of
 * the Interface calls {@link #visitDifferenceNode(DifferenceNode, String, DifferenceVisit)} for each other visit that
 * is not explicitly handled.
 *
 * @author Peter Lamby
 * @param <T> The return type of the visitor.
 */
public interface DifferenceVisitor<T> {
	/**
	 * Called when a node is traversed.
	 *
	 * @param node  The current node.
	 * @param path  The absolut path of the current node.
	 * @param visit The visit that controls the traversal.
	 */
	void visitDifferenceNode(DifferenceNode node, String path, DifferenceVisit<T> visit);

	/**
	 * Called when {@link DifferenceNodes} is traversed.
	 *
	 * @param nodes The current node.
	 * @param path  The absolut path of the current node.
	 * @param visit The visit that controls the traversal.
	 */
	default void visitDifferenceNodes(DifferenceNodes nodes, String path, DifferenceVisit<T> visit) {
		visitDifferenceNode(nodes, path, visit);
	}

	/**
	 * Called when a {@link MapDifferenceNode} is traversed.
	 *
	 * @param node  The current node.
	 * @param path  The absolut path of the current node.
	 * @param visit The visit that controls the traversal.
	 */
	default void visitMapDifferenceNode(MapDifferenceNode node, String path, DifferenceVisit<T> visit) {
		visitDifferenceNode(node, path, visit);
	}
}
