package de.serra.so_dirty.sn;

import org.checkerframework.checker.nullness.qual.Nullable;

/**
 * Creates a {@link SnapshotNode} based on values.
 *
 * @author Peter Lamby
 */
public interface SnapshotNodeFactory {
	/**
	 * Determines if this Factory is responsible for {@code type}.
	 *
	 * @param type The type.
	 * @return {@code true} if the type is supported.
	 */
	boolean supports(Class<?> type);

	/**
	 * Creates an {@link SnapshotNode} for {@code value}. Only call this if the type is {@link #supports(Class)
	 * supported}.
	 *
	 * @param value The value for which to create an SnapshotNode.
	 * @return The created node
	 */
	@Nullable
	SnapshotNode toSnapshotNode(Object value);
}
