/*
 * Decompiled with CFR 0.152.
 */
package de.serra.so_dirty.difference;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DifferenceVisit<@UnknownKeyFor T> {
    private final @UnknownKeyFor @NonNull @Initialized StringBuilder pathPrefixBuffer;
    private @UnknownKeyFor @NonNull @Initialized Action action = Action.CONTINUE;
    private T value;

    public DifferenceVisit(T value) {
        this.value = value;
        this.pathPrefixBuffer = new StringBuilder();
    }

    DifferenceVisit(T value, @UnknownKeyFor @NonNull @Initialized CharSequence path) {
        this.value = value;
        this.pathPrefixBuffer = new StringBuilder(path);
    }

    public void stop() {
        this.action = Action.STOP;
    }

    public void stop(T value) {
        this.action = Action.STOP;
        this.value = value;
    }

    public void dontGoDeeper() {
        this.action = Action.CONTINUE_BUT_DONT_GO_DEEPER;
    }

    public T value() {
        return this.value;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isStopped() {
        return this.action == Action.STOP;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDontGoDeeper() {
        return this.action == Action.STOP || this.action == Action.CONTINUE_BUT_DONT_GO_DEEPER;
    }

    @UnknownKeyFor @NonNull @Initialized String appendPathPrefix(@UnknownKeyFor @NonNull @Initialized String path) {
        this.pathPrefixBuffer.append(path);
        return this.pathPrefixBuffer.toString();
    }

    @UnknownKeyFor @NonNull @Initialized CharSequence pathPrefix() {
        return this.pathPrefixBuffer;
    }

    static enum Action {
        STOP,
        CONTINUE,
        CONTINUE_BUT_DONT_GO_DEEPER;

    }
}

