/*
 * Decompiled with CFR 0.152.
 */
package de.serra.so_dirty.sn;

import de.serra.so_dirty.sn.ClassSnapshotNode;
import de.serra.so_dirty.sn.SnapshotNode;
import de.serra.so_dirty.sn.SnapshotNodeFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ClassSnapshotNodeFactory
implements SnapshotNodeFactory {
    private final @UnknownKeyFor @NonNull @Initialized SnapshotNodeFactory memberFactory;

    public ClassSnapshotNodeFactory(@UnknownKeyFor @NonNull @Initialized SnapshotNodeFactory memberFactory) {
        this.memberFactory = memberFactory;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean supports(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type) {
        return !type.isPrimitive() && !type.isEnum() && !type.isArray() && !type.isSynthetic() && !type.isInterface() && !type.isAnnotation();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ClassSnapshotNode toSnapshotNode(@UnknownKeyFor @NonNull @Initialized Object value) {
        Field[] fields = value.getClass().getDeclaredFields();
        HashMap<String, @Nullable SnapshotNode> fieldsToNodes = new HashMap<String, SnapshotNode>(fields.length);
        for (Field field : fields) {
            Object fieldValue;
            if (field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || !field.canAccess(value) && !field.trySetAccessible() || (fieldValue = this.getFieldValue(field, value)) == null || !this.memberFactory.supports(fieldValue.getClass())) continue;
            fieldsToNodes.put(field.getName(), this.memberFactory.toSnapshotNode(fieldValue));
        }
        return new ClassSnapshotNode(value, fieldsToNodes);
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"}, justification="The exception should never happen since we check canAccess and trySetAccessible first")
    private @Nullable @UnknownKeyFor @Initialized Object getFieldValue(@UnknownKeyFor @NonNull @Initialized Field field, @UnknownKeyFor @NonNull @Initialized Object value) {
        try {
            return field.get(value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Can not access field that should be accessible according to our checks", e);
        }
    }
}

